



/**********************************************************************************************
 *                                                                                            *
 * Ex4.      :   Read Status Detect  at Connecter OUT of Module                               *
 *                                                                                            *
 *              -Befor Run program Save Distance Detect at 10 cm on Module                    *
 *              -Status Detect=0 when Current Distance < Detect Distance(10cm)                * 
 *                                                                                            *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU     : AT89C51RE2 (CP-JR51RE2 V1.0)                                              *
 * Editor         : uvision3 3.62c                                                            *       
 * Compiler       : Keil C51 (V9.51)                                                          *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 * Last Update    : 16/October/2014                                                           *
 *															                                  *
 * Port Interface : # MCU-89C51RE2 #                  # Module ET-REMOTE Distance #           *
 *                  --------------                         --------------------               *
 *                                                                                            *
 *                  P1[0..7](Output)          Connect     LED Common Anode                    *
 *                  P0.0(Input)(Read Status)  Connect     P1 Connector OUT                    *
 *                                                        Disable Filter                      *
 *                                                                                            *
 *                                                        5V                                  *
 *                                                       -+-                                  *
 *                                         \\             |                                   *
 *             (Active'0') P1.0-----------|<|-------------+                                   *
 *                                    .                   |                                   *
 *                                    .                   |                                   *
 *                                    .    \\             |                                   *
 *                         P1.7-----------|<|-------------+                                   *
 *                                                                                            * 
 *                                                                                            * 
 *   Operation  : Read Status Detector by Set Distance for Detect at 10 cm.                   *
 *                When Current Distance less 10 cm LED P1 ON if more 10 cm LED P1 OFF         *   
 *                                                                                            *                                                 
 *                                                                                            *
 **********************************************************************************************/
  						
#include <at89c51xd2.h>
#include <stdio.h>
 
 unsigned int cnt =0                  ;  //valiable delay Counter timer0
 
//-----------Initial Funtion -------------

void Timer0_Init(void)                ;


//---------- Delay -------------
void delay_ms(unsigned int count)     ;


/********************************************
 **             Function Delay(ms)         **
 ********************************************/

//--------- delay ms ----------
void delay_ms(unsigned int count)          
 {
   	
    TR0 = 1        ;   //On Timer0
    ET0 = 1        ;   //Enable INT. Timer0
    cnt = 0        ;   //Start counter delay 	  

    while(cnt<count){;}

    TR0 = 0        ;	//off Timer0
    ET0 = 0        ;	//Disable INT. Timer0
 }


/***************************************************************
 **                                                           **
 **      Interrupt Service Timer0 (Interrupt every 1 ms)      **
 **                                                           **
 ***************************************************************/

//------- Interrupt Service Timer0 every 1 ms ------

 void TM0_Mod1() interrupt 1 
 {
 
  TF0  = 0         ; //Clear int. flag 
  TH0  = 0xF4      ; //Up date 16bit Reload Timer0
  TL0  = 0x00      ; //0xF400 = 1 ms 

  cnt = cnt+1      ; //Counter for Cursor blink

 }



/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/


void main (void) 
  {
       
     CKCON0 = 0x01            ;  // div 6 clk mode  X2=1
     AUXR   = 0x10            ;  //Set XRAM = 1792 Byte

	 Timer0_Init()            ;   

     delay_ms(200)            ;  //Wait Module ET-Remote Distance Ready when Power On
    
	 P1 = 0xFF                ;  //Set Defalut P1 OFF LED
	 P0_0 = 1                 ;  //Set P0_0 =Input
	 
	//----------------- Start Read Status Detecter --------------

    while(1)
    {    
	  if(P0_0 == 0)             //Check Status Detect P0.0 if Current Distance < 10 Cm , P0.0 = 0
		P1 = 0x00             ; //LED P1 ON
      else
		P1 = 0xFF             ; //LED P1 OFF
   }
 }


 /**********************************************************
  **                                                      **  
  **                       Sub-Program                    ** 
  **                                                      **
  **********************************************************/


 /*********************************************
  *              Initial Timer0               *
  *********************************************/
 
 void Timer0_Init(void)
 {		
  //------- Initial Timer0 Control Cursor ---------

  TH0	= 0xF4   ;	//Start Interrupt every 1 ms
  TL0   = 0x00   ;
  	 
  TMOD |= 0x01   ; //Use Timer0 Mode1 16-bit																							    
   ET0  = 0	     ; //Disable Timer0 Interrupt 
   TR0  = 0      ; //Set TCON Reg. Off Timer0

   EA   = 1      ;  //Enable global Interrupt  
 }						   


